% estimatePrior: Estimate illuminant color with illuminant prior
%
% w = estimatePrior(imgpc,saveloc)
%
%   imgpc:   Name of .mat file with precomputed data from precompute
%   saveloc: Name of .mat file with training data
%            (use the svloc that was passed to trainPrior, the
%            .w.mat will be appended automatically)
%
% RESULT:
%   w:       3x1 Vector corresponding to illuminant color
%
% Note, this requires that estimate has already been called on the
% image, and that a imgpc.w.mat has been created.
function ell = estimatePrior(imgpc,saveloc)

  A = []; NK = []; ell = []; Q = []; alpha = [];
  load('-mat',[saveloc '.w.mat']);
  load('-mat',[imgpc '.w.mat']);
  
  A = (A*NK + alpha*sum(ell.^2)*Q) / (NK + 2*alpha);
  ell = atoell(A);
  ell = ell(:) / sqrt(sum(ell.^2));
  
function ell = atoell(A)
  
  ell = sqrt(diag(A));
  C = inf;
  for it = 1:40
    for i = 1:3
      sj = sum(A(:,i) ./ ell(:)) - A(i,i)/ell(i);
      ell(i) = 0.5*(sj + sqrt(sj^2 + 4*A(i,i)));
    end;
    Cn = sum(log(ell)) + 0.5*ell'*A*ell;
    if Cn > (1-10^-4)*C
      break;
    end;
    C = Cn;
  end;
